#NoTrayIcon

#include <Constants.au3>
#include 'AutoItErrorHandler.au3'

If Not _OnAutoItErrorRegister('_MyErrorHandler') Then
	Switch @error
		Case -1
			;If Not @Compiled Then
				MsgBox(48, @ScriptName, 'ATM, only compiled script is supported, please compile the script.')
			;EndIf
		Case 1
			;If Not StringRegExp(@AutoItVersion, '^3\.3\.(12\.0|9\.4|8\.\d+|6\.\d+)$') Then
				MsgBox(48, @ScriptName, 'ATM, only these AutoIt versions are supported:' & @CRLF & '3.3.12.0 / 3.3.9.4 / 3.3.8.X / 3.3.6.X')
			;EndIf
	EndSwitch
	
	Exit
EndIf

;We deliberately make an array bounding error and call the error!
Dim $aArr[1]
MsgBox(0, '', $aArr[1])

MsgBox(64, @ScriptName, 'We can continue!!!' & @CRLF & 'Now we set other AutoIt Error Handler (default error msg handler), and trigger some error...')
_OnAutoItErrorRegister('')

$aArr[3] = $aArr

Func _MyErrorHandler($sScriptPath, $iScriptLine, $sErrDesc, $vParams, $hBitmap)
	Local $sMessage = StringFormat('SCRIPT FILE:\n%s\n\nSCRIPT ERROR LINE:\n%s\n\nERROR DESCRIPTION:\n%s', $sScriptPath, $iScriptLine, $sErrDesc)
	
	If FileExists(@WindowsDir & '\Media\chord.wav') Then
		SoundPlay(@WindowsDir & '\Media\chord.wav')
	Else
		DllCall('user32.dll', 'int', 'MessageBeep', 'int', 0x00000010)
	EndIf
	
	If MsgBox(BitOR($MB_SYSTEMMODAL, $MB_YESNO), 'Crash recieved!', 'Restart application?' & @CRLF & '(if you press "No", the script will continue from next line)' & @CRLF & @CRLF & $sMessage) <> 6 Then
		Return $iAEH_CONTINUE_PROC
	EndIf
	
	Local $sRunLine = @AutoItExe & ' "' & @ScriptFullPath & '"'
	
	If @Compiled Then
		$sRunLine = @ScriptFullPath
	EndIf
	
	Run($sRunLine, @ScriptDir)
	Return $iAEH_TERMINATE_PROC
EndFunc
